/**************************************************************************************
  $Id: OS_Specific.c 13823 2020-11-26 14:16:02Z RMayer $

  Description:
    Win32 OS Abstraction Layer implementation.

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    ????-??-??  created (unknown source)

 **************************************************************************************/

#include "OS_Dependent.h"
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <Windows.h>

/*****************************************************************************/
/*!  \addtogroup MARSHALLER_TK_OS_ABSTRACTION Operating System Abstraction
*    \{                                                                      */
/*****************************************************************************/

/*****************************************************************************/
/*! Memory allocation function
*   NOTE: Malloc with size 0 should be prevented and returns a NULL pointer
*   \param ulSize    Length of memory to allocate
*   \return Pointer to allocated memory                                      */
/*****************************************************************************/
void* OS_Malloc(uint32_t ulSize)
{
  if( 0 == ulSize)
    return NULL;

  return malloc(ulSize);
}

/*****************************************************************************/
/*! Memory freeing function
*   \param pvMem Memory block to free                                        */
/*****************************************************************************/
void OS_Free(void* pvMem)
{
  free(pvMem);
}

/*****************************************************************************/
/*! Memory setting
*   \param pvMem     Memory block
*   \param bFill     Byte to use for memory initialization
*   \param ulSize    Memory size for initialization)                         */
/*****************************************************************************/
void OS_Memset(void* pvMem, uint8_t bFill, uint32_t ulSize)
{
  memset(pvMem, bFill, ulSize);
}

/*****************************************************************************/
/*! Copy memory from one block to another
*   \param pvDest    Destination memory block
*   \param pvSrc     Source memory block
*   \param ulSize    Copy size in bytes                                      */
/*****************************************************************************/
void OS_Memcpy(void* pvDest, void* pvSrc, uint32_t ulSize)
{
  memcpy(pvDest, pvSrc, ulSize);
}

/*****************************************************************************/
/*! Compare two memory blocks
*   \param pvBuf1    First memory block
*   \param pvBuf2    Second memory block
*   \param ulSize    Compare size in bytes
*   \return 0 if both buffers are equal                                      */
/*****************************************************************************/
int OS_Memcmp(void* pvBuf1, void* pvBuf2, uint32_t ulSize)
{
  return memcmp(pvBuf1, pvBuf2, ulSize);
}

/*****************************************************************************/
/*! Compare two ASCII string
*   \param pszBuf1   First buffer
*   \param pszBuf2   Second buffer
*   \return 0 if strings are equal                                           */
/*****************************************************************************/
int OS_Strcmp(const char* pszBuf1, const char* pszBuf2)
{
  return strcmp(pszBuf1, pszBuf2);
}

/*****************************************************************************/
/*! Compare characters of two strings without regard to case
*   \param pszBuf1   First buffer
*   \param pszBuf2   Second buffer
*   \param ulLen     Number of characters to compare
*   \return 0 if strings are equal                                           */
/*****************************************************************************/
int OS_Strnicmp(const char* pszBuf1, const char* pszBuf2, uint32_t ulLen)
{
  return _strnicmp(pszBuf1, pszBuf2, ulLen);
}

/*****************************************************************************/
/*! Query the length of an ASCII string
*   \param szText    ASCII string
*   \return character count of szText                                        */
/*****************************************************************************/
int OS_Strlen(const char* szText)
{
  return (int)strlen(szText);
}

/*****************************************************************************/
/*! Copies one string to another monitoring the maximum length of the target
*   buffer.
*   \param szDest    Destination buffer
*   \param szSource  Source buffer
*   \param ulLength  Maximum length to copy
*   \return pointer to szDest                                                */
/*****************************************************************************/
char* OS_Strncpy(char* szDest, const char* szSource, uint32_t ulLength)
{
  return strncpy(szDest, szSource, ulLength);
}

/*****************************************************************************/
/*! Get lock object
*   \return  a LOCK ID (always 1) if lock is available                       */
/*****************************************************************************/
CRITICAL_SECTION g_tcsQueueLock;
int OS_Lock(void)
{
  EnterCriticalSection(&g_tcsQueueLock);
  return 1;
}

/*****************************************************************************/
/*! Free lock object
*   \param iLock  Lock ID                                                    */
/*****************************************************************************/
void OS_Unlock(int iLock)
{
  UNREFERENCED_PARAMETER(iLock);
  LeaveCriticalSection(&g_tcsQueueLock);
}

/*****************************************************************************/
/*! Get Millisecond counter value (used for timeout handling)
*   Retrieves the number of milliseconds that have elapsed since the system
*   was started.
*   Note: Depending on the timer resolution this value can wrap around
*     \return Counter value with a resolution of 1ms                         */
/*****************************************************************************/
uint32_t OS_GetTickCount(void)
{
  return GetTickCount();
}

/*****************************************************************************/
/*! \}                                                                       */
/*****************************************************************************/